/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.haml.internal;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.common.text.reconciler.Messages;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;

public class HAMLFoldingComputer
implements IFoldingComputer {
    private IDocument fDocument;
    private AbstractThemeableEditor fEditor;

    public HAMLFoldingComputer(AbstractThemeableEditor editor, IDocument document) {
        this.fDocument = document;
        this.fEditor = editor;
    }

    public Map<ProjectionAnnotation, Position> emitFoldingRegions(boolean initialReconcile, IProgressMonitor monitor, IParseRootNode ast) throws BadLocationException {
        int lineCount = this.fDocument.getNumberOfLines();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CommonReconcilingStrategy_FoldingTaskName, (int)lineCount);
        if (lineCount <= 1) {
            return Collections.emptyMap();
        }
        HashMap<ProjectionAnnotation, Position> newPositions = new HashMap<ProjectionAnnotation, Position>(lineCount >> 2);
        Stack<Integer> indentLevels = new Stack<Integer>();
        indentLevels.push(0);
        HashMap<Integer, Integer> starts = new HashMap<Integer, Integer>(3);
        int currentLine = 0;
        while (currentLine < lineCount) {
            if (subMonitor.isCanceled()) {
                return newPositions;
            }
            IRegion lineRegion = this.fDocument.getLineInformation(currentLine);
            int offset = lineRegion.getOffset();
            String line = this.fDocument.get(offset, lineRegion.getLength());
            if (line.trim().length() != 0) {
                int indent = this.findIndent(line);
                if (!indentLevels.isEmpty()) {
                    int peekedIndent = (Integer)indentLevels.peek();
                    if (indent > peekedIndent) {
                        indentLevels.push(indent);
                        starts.put(indent, offset);
                    } else if (indent == peekedIndent) {
                        starts.put(indent, offset);
                    } else if (indent < peekedIndent) {
                        while (!indentLevels.isEmpty() && indent <= (Integer)indentLevels.peek()) {
                            int end;
                            int posLength;
                            int toPop = (Integer)indentLevels.pop();
                            if (!starts.containsKey(toPop)) continue;
                            int startingOffset = (Integer)starts.remove(toPop);
                            IRegion startLine = this.fDocument.getLineInformationOfOffset(startingOffset);
                            IRegion endLine = this.fDocument.getLineInformation(currentLine - 1);
                            if (startLine.getOffset() == endLine.getOffset() || (posLength = (end = endLine.getOffset() + endLine.getLength() + 1) - startingOffset) <= 0) continue;
                            Position position = new Position(startingOffset, posLength);
                            newPositions.put(new ProjectionAnnotation(), position);
                        }
                        starts.put(indent, offset);
                    }
                }
                subMonitor.worked(1);
            }
            ++currentLine;
        }
        int documentEnd = this.fDocument.getLength();
        IRegion endLine = this.fDocument.getLineInformationOfOffset(documentEnd);
        for (Integer startingOffset : starts.values()) {
            int posLength;
            IRegion startLine = this.fDocument.getLineInformationOfOffset(startingOffset.intValue());
            if (startLine.getOffset() == endLine.getOffset() || (posLength = documentEnd - startingOffset) <= 0) continue;
            Position position = new Position(startingOffset.intValue(), posLength);
            newPositions.put(new ProjectionAnnotation(), position);
        }
        subMonitor.done();
        return newPositions;
    }

    private int findIndent(String text) {
        int indent = 0;
        while (indent < text.length()) {
            char c = text.charAt(indent);
            if (c == '\t') {
                indent += this.getTabSize();
                continue;
            }
            if (!Character.isWhitespace(c)) break;
            ++indent;
        }
        return indent;
    }

    protected int getTabSize() {
        return this.fEditor.getTabSize();
    }
}

